-- Owner für DemoDaten
SET SESSION AUTHORIZATION 'DEMODATA';

INSERT INTO adk
  (ad_krz, ad_name, ad_vorn, ad_ort, ad_landiso, ad_land)
VALUES
  ('LA', 'Lohn',   'Max',   'Dresden', 'DE', 'Deutschland'), -- Lohnempfänger
  ('GA', 'Gehalt', 'Erika', 'Dresden', 'DE', 'Deutschland'), -- Gehaltsempfänger
  ('AZ', 'Azubi',  'Otto',  'Dresden', 'DE', 'Deutschland')  -- Auszubildender
;

INSERT INTO personal
  (pers_krz, pers_entgelt)
VALUES
  ('LA', 'LOHN'), -- Entgelt-Gruppe Lohn
  ('GA', 'GEHA'), -- Entgelt-Gruppe Gehalt
  ('AZ', 'AZUBI') -- Entgelt-Gruppe Ausbildungsvergütung
;

-- Tagespläne
INSERT INTO tplan
  (tpl_name, tpl_rbegin, tpl_rend, tpl_min, tpl_minpause)
VALUES
  ('Frühschicht',  '06:00', '14:00', 7.5, NULL),  -- Frühschicht mit fester Pause
  ('Spätschicht',  '14:00', '22:00', 7.5, NULL),  -- Spätschicht mit globaler Mindestpause
  ('Nachtschicht', '22:00', '06:00', 7.5, 0.5),   -- Nachtschicht mit expliziter Mindestpause
  ('Gleitzeit',    '08:00', '18:00', 8,   NULL)   -- Gleitzeit mit globaler Mindestpause
;

-- feste Pausen
INSERT INTO tplanpause
  (tplp_tpl_name, tplp_begin, tplp_end, tplp_min)
VALUES
  ('Frühschicht',  '07:30', '09:30', 30)   -- Pause zu nehmen in der Zeit für Frühschicht
;

-- globale Mindestpausen, siehe "Z Predefined.sql" (INTO minpause)

-- Zeiträume für Zeitrundung
INSERT INTO karenz
  (kr_tpl_name, kr_anf, kr_end, kr_newtime)
VALUES
  ('Frühschicht',   '05:00', '06:05', '06:00'), -- Frühschicht-Anfang   auf 06:00
  ('Frühschicht',   '13:55', '15:00', '14:00'), -- Frühschicht-Ende     auf 14:00
  ('Spätschicht',   '13:00', '14:05', '14:00'), -- Spätschicht-Anfang   auf 14:00
  ('Spätschicht',   '21:55', '23:00', '22:00'), -- Spätschicht-Ende     auf 22:00
  ('Nachtschicht',  '21:00', '22:05', '22:00'), -- Nachtschicht-Anfang  auf 22:00
  ('Nachtschicht',  '05:55', '07:00', '06:00')  -- Nachtschicht-Ende    auf 06:00
;

-- Eintrag im Mitarbeiterverzeichnis mit Standard-Tagesplan
INSERT INTO llv
  (ll_minr, ll_ad_krz, ll_db_usename, ll_standplan_mo, ll_standplan_di, ll_standplan_mi, ll_standplan_do, ll_standplan_fr)
VALUES
  (1001, 'LA', 'LA', 'Frühschicht', 'Frühschicht', 'Frühschicht', 'Frühschicht', 'Frühschicht'),
  (1002, 'GA', 'GA', 'Gleitzeit',   'Gleitzeit',   'Gleitzeit',   'Gleitzeit',   'Gleitzeit'),
  (1003, 'AZ', 'AZ', 'Frühschicht', 'Frühschicht', 'Frühschicht', 'Frühschicht', 'Frühschicht')
;

-- automatische Tagesplan-Zuordnung entspr. Anstempelzeit
INSERT INTO llv_autoplan
  (llpl_minr, llpl_anf, llpl_end, llpl_tpl_name, llpl_tpl_name_fr, llpl_tpl_name_sa, llpl_tpl_name_so)
VALUES
  (1001, '05:00', '07:00', 'Frühschicht',   'Frühschicht',  'Frühschicht',  'Frühschicht'),
  (1001, '13:00', '15:00', 'Spätschicht',   'Spätschicht',  'Spätschicht',  'Spätschicht'),
  (1001, '21:00', '23:00', 'Nachtschicht',  'Nachtschicht', 'Nachtschicht', 'Nachtschicht'),
  (1003, '05:00', '07:00', 'Frühschicht',   'Frühschicht',  'Frühschicht',  'Frühschicht'),
  (1003, '13:00', '15:00', 'Spätschicht',   'Spätschicht',  'Spätschicht',  'Spätschicht'),
  (1003, '21:00', '23:00', 'Nachtschicht',  'Nachtschicht', 'Nachtschicht', 'Nachtschicht')
;

-- Feiertage 2019
INSERT INTO feiertag
  (ft_date, ft_bez, ft_stu)
VALUES
  ('2019-01-01', 'Neujahr',                   0),
  ('2019-04-19', 'Karfreitag',                0),
  ('2019-04-22', 'Ostermontag',               0),
  ('2019-05-01', 'Tag der Arbeit',            0),
  ('2019-05-30', 'Christi Himmelfahrt',       0),
  ('2019-06-10', 'Pfingstmontag',             0),
  ('2019-10-03', 'Tag der Deutschen Einheit', 0),
  ('2019-10-31', 'Reformationstag',           0),
  ('2019-12-25', '1. Weihnachtstag',          0),
  ('2019-12-26', '2. Weihnachtstag',          0)
;

-- Stempelzeiten von MA Lohnempfänger (1001), Juni 2019
    -- DELETE FROM bdep WHERE bd_minr = 1001 AND bd_anf::DATE BETWEEN '01.06.2019' AND '01.07.2019';
    -- DELETE FROM mitpln WHERE mpl_minr = 1001 AND mpl_date BETWEEN '01.06.2019' AND '01.07.2019';
    DO $$
    DECLARE dat DATE = '2019-05-31';
            mnr INTEGER = 1001;
    BEGIN
      INSERT INTO bdep
        (bd_minr, bd_anf                 , bd_end                 )  -- Zeitrundungen entspr. TABLE karenz initial aktiviert (bd_karenz und bd_karenz_end DEFAULT true)
      VALUES
       -- 1. Monat
        (mnr    , dat + 3  + time '05:45', dat + 3  + time '08:21'), -- Mo 03.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 3  + time '08:54', dat + 3  + time '14:48'), -- Mo 03.06. Frühschicht bis Ende

        (mnr    , dat + 4  + time '06:00', dat + 4  + time '08:00'), -- Di 04.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 4  + time '08:54', dat + 4  + time '14:45'), -- Di 04.06. Frühschicht bis Ende

        (mnr    , dat + 5  + time '05:48', dat + 5  + time '14:42'), -- Mi 05.06. Frühschicht bis Ende, autom. Pause

        (mnr    , dat + 6  + time '05:48', dat + 6  + time '08:12'), -- Do 06.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 6  + time '08:42', dat + 6  + time '14:51'), -- Do 06.06. Frühschicht bis Ende

        (mnr    , dat + 7  + time '06:15', dat + 7  + time '08:03'), -- Fr 07.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 7  + time '08:33', dat + 7  + time '13:24'), -- Fr 07.06. Frühschicht bis Ende


        (mnr    , dat + 11 + time '14:15', dat + 11 + time '19:30'), -- Di 11.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 11 + time '20:00', dat + 11 + time '23:39'), -- Di 11.06. Spätschicht bis Ende

        (mnr    , dat + 12 + time '14:06', dat + 12 + time '19:30'), -- Mi 12.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 12 + time '20:00', dat + 12 + time '23:48'), -- Mi 12.06. Spätschicht bis Ende

        (mnr    , dat + 13 + time '14:21', dat + 13 + time '19:30'), -- Do 13.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 13 + time '20:00', dat + 14 + time '00:12'), -- Do 13.06. Spätschicht bis Ende

        (mnr    , dat + 14 + time '14:12', dat + 14 + time '20:00'), -- Fr 14.06. Spätschicht bis Ende, autom. Pause

        (mnr    , dat + 15 + time '05:21', dat + 15 + time '13:00'), -- Sa 15.06. Frühschicht bis Ende, autom. Pause


        (mnr    , dat + 16 + time '22:03', dat + 17 + time '02:06'), -- So 16.06. Nachtschicht bis (gestempelte) Pause
        (mnr    , dat + 17 + time '02:36', dat + 17 + time '06:15'), -- Mo 17.06. Nachtschicht bis Ende

        (mnr    , dat + 17 + time '21:57', dat + 18 + time '01:57'), -- Mo 17.06. Nachtschicht bis (gestempelte) Pause
        (mnr    , dat + 18 + time '02:30', dat + 18 + time '06:03'), -- Di 18.06. Nachtschicht bis Ende

        (mnr    , dat + 18 + time '22:06', dat + 19 + time '02:42'), -- Di 18.06. Nachtschicht bis (gestempelte) Pause
        (mnr    , dat + 19 + time '03:12', dat + 19 + time '06:27'), -- Mi 19.06. Nachtschicht bis Ende

        (mnr    , dat + 19 + time '21:54', dat + 20 + time '02:06'), -- Mi 19.06. Nachtschicht bis (gestempelte) Pause
        (mnr    , dat + 20 + time '02:30', dat + 20 + time '05:00'), -- Do 20.06. Nachtschicht bis (gestempelte) Pause 2
        (mnr    , dat + 20 + time '05:09', dat + 20 + time '06:15'), -- Do 20.06. Nachtschicht bis Ende

        (mnr    , dat + 20 + time '21:54', dat + 21 + time '01:27'), -- Do 20.06. Nachtschicht bis (gestempelte) Pause
        (mnr    , dat + 21 + time '02:03', dat + 21 + time '06:21'), -- Fr 21.06. Nachtschicht bis Ende


        (mnr    , dat + 24 + time '14:15', dat + 24 + time '19:30'), -- Mo 24.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 24 + time '20:00', dat + 25 + time '00:12'), -- Mo 24.06. Spätschicht bis Ende

        (mnr    , dat + 25 + time '14:21', dat + 25 + time '19:27'), -- Di 25.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 25 + time '20:00', dat + 25 + time '23:45'), -- Di 25.06. Spätschicht bis Ende

        (mnr    , dat + 26 + time '14:27', dat + 26 + time '19:30'), -- Mi 26.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 26 + time '20:00', dat + 26 + time '23:06'), -- Mi 26.06. Spätschicht bis Ende

        (mnr    , dat + 27 + time '06:12', dat + 27 + time '08:36'), -- Do 27.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 27 + time '09:03', dat + 27 + time '14:21'), -- Do 27.06. Frühschicht bis Ende

        (mnr    , dat + 28 + time '14:15', dat + 28 + time '20:03'), -- Fr 28.06. Spätschicht bis Ende, autom. Pause


        (mnr    , dat + 30 + time '21:57', dat + 31 + time '02:54'), -- So 30.06. Nachtschicht bis (gestempelte) Pause
        (mnr    , dat + 31 + time '03:21', dat + 31 + time '06:09')  -- Mo 01.07. Nachtschicht bis Ende
      ;

      dat := '2019-06-30';

      INSERT INTO bdep
        (bd_minr, bd_anf                           , bd_end)
      VALUES
        (mnr    , dat + integer '1' + time '21:45' , dat + integer '2' + time '00:39'),
        (mnr    , dat + integer '2' + time '01:12' , dat + integer '2' + time '06:06'),

        (mnr    , dat + integer '2' + time '21:48' , dat + integer '3' + time '02:09'),
        (mnr    , dat + integer '3' + time '02:42' , dat + integer '3' + time '06:24'),

        (mnr    , dat + integer '3' + time '21:54' , dat + integer '4' + time '00:00'),
        (mnr    , dat + integer '4' + time '00:30' , dat + integer '4' + time '06:03'),

        (mnr    , dat + integer '4' + time '21:54' , dat + integer '5' + time '00:09'),
        (mnr    , dat + integer '5' + time '00:42' , dat + integer '5' + time '06:12'),


        (mnr    , dat + integer '8' + time '14:24' , dat + integer '8' + time '15:39'),
        (mnr    , dat + integer '8' + time '15:45' , dat + integer '8' + time '19:48'),
        (mnr    , dat + integer '8' + time '20:27' , dat + integer '8' + time '20:42'),
        (mnr    , dat + integer '8' + time '20:48' , dat + integer '8' + time '23:48'),

        (mnr    , dat + integer '9' + time '14:21', dat + integer '9' + time '17:21'),
        (mnr    , dat + integer '9' + time '17:27', dat + integer '9' + time '19:09'),
        (mnr    , dat + integer '9' + time '19:30', dat + integer '9' + time '23:06'),

        (mnr    , dat + integer '10' + time '14:09', dat + integer '10' + time '15:33'),
        (mnr    , dat + integer '10' + time '15:51', dat + integer '10' + time '19:48'),
        (mnr    , dat + integer '10' + time '20:06', dat + integer '10' + time '23:30'),

        (mnr    , dat + integer '11' + time '14:24', dat + integer '11' + time '16:12'),
        (mnr    , dat + integer '11' + time '16:18', dat + integer '11' + time '18:00'),
        (mnr    , dat + integer '11' + time '18:27', dat + integer '11' + time '23:36'),

        (mnr    , dat + integer '12' + time '14:24', dat + integer '12' + time '20:06'),


        (mnr    , dat + integer '14' + time '21:57', dat + integer '15' + time '02:30'),
        (mnr    , dat + integer '15' + time '03:00', dat + integer '15' + time '06:06'),

        (mnr    , dat + integer '15' + time '21:48', dat + integer '16' + time '01:30'),
        (mnr    , dat + integer '16' + time '01:57', dat + integer '16' + time '06:18'),

        (mnr    , dat + integer '16' + time '21:54', dat + integer '17' + time '00:00'),
        (mnr    , dat + integer '17' + time '00:27', dat + integer '17' + time '02:33'),

        (mnr    , dat + integer '17' + time '21:57', dat + integer '18' + time '02:03'),
        (mnr    , dat + integer '18' + time '02:33', dat + integer '18' + time '06:21'),

        (mnr    , dat + integer '18' + time '21:48', dat + integer '19' + time '03:36');

       dat := '2019-07-31';
      INSERT INTO bdep
        (bd_minr, bd_anf                           , bd_end)
      VALUES
        (mnr    , dat + integer '12' + time '21:42' , dat + integer '13' + time '03:03'),
        (mnr    , dat + integer '13' + time '03:33' , dat + integer '13' + time '06:06'),

        (mnr    , dat + integer '13' + time '21:51' , dat + integer '14' + time '02:24'),
        (mnr    , dat + integer '14' + time '02:51' , dat + integer '14' + time '06:09'),

        (mnr    , dat + integer '14' + time '21:54' , dat + integer '15' + time '03:00'),
        (mnr    , dat + integer '15' + time '03:27' , dat + integer '15' + time '06:12'),

        (mnr    , dat + integer '15' + time '21:42' , dat + integer '16' + time '02:18'),
        (mnr    , dat + integer '16' + time '02:48' , dat + integer '16' + time '06:21'),


        (mnr    , dat + integer '19' + time '05:45' , dat + integer '19' + time '08:12'),
        (mnr    , dat + integer '19' + time '08:48' , dat + integer '19' + time '14:45'),

        (mnr    , dat + integer '20' + time '06:03' , dat + integer '20' + time '07:57'),
        (mnr    , dat + integer '20' + time '08:27' , dat + integer '20' + time '14:45'),

        (mnr    , dat + integer '21' + time '05:57', dat + integer '21' + time '08:18'),
        (mnr    , dat + integer '21' + time '08:51', dat + integer '21' + time '14:54'),

        (mnr    , dat + integer '22' + time '06:12', dat + integer '22' + time '08:03'),
        (mnr    , dat + integer '22' + time '08:33', dat + integer '22' + time '14:51'),

        (mnr    , dat + integer '23' + time '05:39', dat + integer '23' + time '07:57'),
        (mnr    , dat + integer '23' + time '08:24', dat + integer '23' + time '14:03'),

        (mnr    , dat + integer '25' + time '21:42', dat + integer '26' + time '04:09'),
        (mnr    , dat + integer '26' + time '04:36', dat + integer '26' + time '06:09'),

        (mnr    , dat + integer '26' + time '21:48', dat + integer '27' + time '03:45'),
        (mnr    , dat + integer '27' + time '04:15', dat + integer '27' + time '06:03'),

        (mnr    , dat + integer '27' + time '21:51', dat + integer '28' + time '00:09'),
        (mnr    , dat + integer '28' + time '00:39', dat + integer '28' + time '06:06'),

        (mnr    , dat + integer '29' + time '21:57', dat + integer '30' + time '03:27'),
        (mnr    , dat + integer '30' + time '03:48', dat + integer '30' + time '06:12')
        ;

      -- Überstundefreigabe nachträglich
      UPDATE bdep SET
        bd_karenz     = false,
        bd_karenz_end = false
      WHERE bd_minr = mnr;
    END $$;
--

-- Stempelzeiten von MA Gehaltsempfänger (1002), Juni 2019
    -- DELETE FROM bdep WHERE bd_minr = 1002 AND bd_anf::DATE BETWEEN '01.06.2019' AND '01.07.2019';
    -- DELETE FROM mitpln WHERE mpl_minr = 1002 AND mpl_date BETWEEN '01.06.2019' AND '01.07.2019';
    DO $$
    DECLARE dat DATE = '2019-05-31';
            mnr INTEGER = 1002;
    BEGIN
    -- ('Gleitzeit',    '08:00', '18:00', 8,   NULL)   -- Gleitzeit mit globaler Mindestpause
      INSERT INTO bdep
        (bd_minr, bd_anf                 , bd_end                 )  -- Zeitrundungen entspr. TABLE karenz initial aktiviert (bd_karenz und bd_karenz_end DEFAULT true)
      VALUES
        (mnr    , dat + 3  + time '07:45', dat + 3  + time '09:24'), -- Mo 03.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 3  + time '09:54', dat + 3  + time '16:15'), -- Mo 03.06. Gleitzeit bis Ende

        (mnr    , dat + 4  + time '08:00', dat + 4  + time '09:20'), -- Di 04.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 4  + time '09:40', dat + 4  + time '16:35'), -- Di 04.06. Gleitzeit bis Ende

        (mnr    , dat + 5  + time '08:08', dat + 5  + time '16:12'), -- Mi 05.06. Gleitzeit bis Ende, autom. Pause

        (mnr    , dat + 6  + time '08:48', dat + 6  + time '10:12'), -- Do 06.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 6  + time '10:42', dat + 6  + time '16:51'), -- Do 06.06. Gleitzeit bis Ende

        (mnr    , dat + 7  + time '08:15', dat + 7  + time '09:03'), -- Fr 07.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 7  + time '09:33', dat + 7  + time '16:24'), -- Fr 07.06. Gleitzeit bis Ende


        (mnr    , dat + 11 + time '09:15', dat + 11 + time '18:10'), -- Di 11.06.  Gleitzeit bis Ende, autom. Pause

        (mnr    , dat + 12 + time '08:26', dat + 12 + time '09:30'), -- Mi 12.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 12 + time '10:00', dat + 12 + time '16:48'), -- Mi 12.06. Gleitzeit bis Ende

        (mnr    , dat + 13 + time '08:21', dat + 13 + time '09:30'), -- Do 13.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 13 + time '10:00', dat + 13 + time '16:12'), -- Do 13.06. Gleitzeit bis Ende

        (mnr    , dat + 14 + time '08:12', dat + 14 + time '16:00'), -- Fr 14.06. Gleitzeit bis Ende, autom. Pause

        (mnr    , dat + 15 + time '10:21', dat + 15 + time '13:00'), -- Sa 15.06. Gleitzeit bis Ende, autom. Pause


        (mnr    , dat + 17 + time '07:36', dat + 17 + time '16:15'), -- Mo 17.06. Gleitzeit bis Ende, autom. Pause

        (mnr    , dat + 18 + time '07:57', dat + 18 + time '15:57'), -- Di 18.06. Gleitzeit bis Ende, autom. Pause

        (mnr    , dat + 19 + time '08:12', dat + 19 + time '16:27'), -- Mi 19.06. Gleitzeit bis Ende, autom. Pause

        (mnr    , dat + 20 + time '06:54', dat + 20 + time '09:06'), -- Do 20.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 20 + time '09:30', dat + 20 + time '14:00'), -- Do 20.06. Gleitzeit bis (gestempelte) Pause 2
        (mnr    , dat + 20 + time '14:09', dat + 20 + time '15:45'), -- Do 20.06. Gleitzeit bis Ende

        (mnr    , dat + 21 + time '07:54', dat + 21 + time '09:27'), -- Fr 21.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 21 + time '10:03', dat + 21 + time '16:21'), -- Fr 21.06. Gleitzeit bis Ende


        (mnr    , dat + 24 + time '08:15', dat + 24 + time '09:30'), -- Mo 24.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 24 + time '10:00', dat + 24 + time '17:12'), -- Mo 24.06. Gleitzeit bis Ende

        (mnr    , dat + 25 + time '08:21', dat + 25 + time '09:27'), -- Di 25.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 25 + time '10:00', dat + 25 + time '16:45'), -- Di 25.06. Gleitzeit bis Ende

        (mnr    , dat + 26 + time '08:27', dat + 26 + time '09:30'), -- Mi 26.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 26 + time '10:00', dat + 26 + time '16:06'), -- Mi 26.06. Gleitzeit bis Ende

        (mnr    , dat + 27 + time '08:12', dat + 27 + time '09:36'), -- Do 27.06. Gleitzeit bis (gestempelte) Pause
        (mnr    , dat + 27 + time '10:03', dat + 27 + time '15:21'), -- Do 27.06. Gleitzeit bis Ende

        (mnr    , dat + 28 + time '08:15', dat + 28 + time '16:03')  -- Fr 28.06. Gleitzeit bis Ende, autom. Pause
      ;

    END $$;
--

-- Stempelzeiten von MA Auszubildender (1003), Juni 2019
    -- DELETE FROM bdep WHERE bd_minr = 1003 AND bd_anf::DATE BETWEEN '01.06.2019' AND '01.07.2019';
    -- DELETE FROM mitpln WHERE mpl_minr = 1003 AND mpl_date BETWEEN '01.06.2019' AND '01.07.2019';
    DO $$
    DECLARE dat DATE = '2019-05-31';
            mnr INTEGER = 1003;
    BEGIN
      INSERT INTO bdep
        (bd_minr, bd_anf                 , bd_end                 )  -- Zeitrundungen entspr. TABLE karenz initial aktiviert (bd_karenz und bd_karenz_end DEFAULT true)
      VALUES
        (mnr    , dat + 3  + time '05:45', dat + 3  + time '08:21'), -- Mo 03.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 3  + time '08:54', dat + 3  + time '14:48'), -- Mo 03.06. Frühschicht bis Ende

        (mnr    , dat + 4  + time '06:00', dat + 4  + time '08:00'), -- Di 04.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 4  + time '08:54', dat + 4  + time '14:45'), -- Di 04.06. Frühschicht bis Ende

        (mnr    , dat + 5  + time '05:48', dat + 5  + time '14:42'), -- Mi 05.06. Frühschicht bis Ende, autom. Pause

        (mnr    , dat + 6  + time '05:48', dat + 6  + time '08:12'), -- Do 06.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 6  + time '08:42', dat + 6  + time '14:51'), -- Do 06.06. Frühschicht bis Ende

        (mnr    , dat + 7  + time '06:15', dat + 7  + time '08:03'), -- Fr 07.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 7  + time '08:33', dat + 7  + time '13:24'), -- Fr 07.06. Frühschicht bis Ende


        (mnr    , dat + 11 + time '14:15', dat + 11 + time '19:30'), -- Di 11.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 11 + time '20:00', dat + 11 + time '23:39'), -- Di 11.06. Spätschicht bis Ende

        (mnr    , dat + 12 + time '14:06', dat + 12 + time '19:30'), -- Mi 12.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 12 + time '20:00', dat + 12 + time '23:48'), -- Mi 12.06. Spätschicht bis Ende

        (mnr    , dat + 13 + time '14:21', dat + 13 + time '19:30'), -- Do 13.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 13 + time '20:00', dat + 14 + time '00:12'), -- Do 13.06. Spätschicht bis Ende

        (mnr    , dat + 14 + time '14:12', dat + 14 + time '20:00'), -- Fr 14.06. Spätschicht bis Ende, autom. Pause


        (mnr    , dat + 17 + time '05:45', dat + 17 + time '08:21'), -- Mo 17.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 17 + time '08:54', dat + 17 + time '14:48'), -- Mo 17.06. Frühschicht bis Ende

        (mnr    , dat + 18 + time '06:00', dat + 18 + time '08:00'), -- Di 18.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 18 + time '08:54', dat + 18 + time '14:45'), -- Di 18.06. Frühschicht bis Ende

        (mnr    , dat + 19 + time '05:48', dat + 19 + time '14:42'), -- Mi 19.06. Frühschicht bis Ende, autom. Pause

        (mnr    , dat + 20 + time '05:48', dat + 20 + time '08:12'), -- Do 20.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 20 + time '08:42', dat + 20 + time '14:51'), -- Do 20.06. Frühschicht bis Ende

        (mnr    , dat + 21 + time '06:15', dat + 21 + time '08:03'), -- Fr 21.06. Frühschicht bis (gestempelte) Pause
        (mnr    , dat + 21 + time '08:33', dat + 21 + time '13:24'), -- Fr 21.06. Frühschicht bis Ende


        (mnr    , dat + 24 + time '14:15', dat + 24 + time '19:30'), -- Mo 24.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 24 + time '20:00', dat + 25 + time '00:12'), -- Mo 24.06. Spätschicht bis Ende

        (mnr    , dat + 25 + time '14:21', dat + 25 + time '19:27'), -- Di 25.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 25 + time '20:00', dat + 25 + time '23:45'), -- Di 25.06. Spätschicht bis Ende

        (mnr    , dat + 26 + time '14:27', dat + 26 + time '19:30'), -- Mi 26.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 26 + time '20:00', dat + 26 + time '23:06'), -- Mi 26.06. Spätschicht bis Ende

        (mnr    , dat + 27 + time '14:12', dat + 27 + time '18:36'), -- Do 27.06. Spätschicht bis (gestempelte) Pause
        (mnr    , dat + 27 + time '19:03', dat + 27 + time '23:21'), -- Do 27.06. Spätschicht bis Ende

        (mnr    , dat + 28 + time '14:15', dat + 28 + time '20:03')  -- Fr 28.06. Spätschicht bis Ende, autom. Pause
      ;

      -- Überstundefreigabe nachträglich
      UPDATE bdep SET
        bd_karenz     = false,
        bd_karenz_end = false
      WHERE bd_minr = mnr;
    END $$;
--

-- END DEMO-SESSION
RESET SESSION AUTHORIZATION;